/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1299;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2069;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2135;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4711;
import net.minecraft.class_5258;
import net.minecraft.class_5409;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.CountRequirementsStrategy;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.ToolPredicate;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.SearedLanternBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

public class AdvancementsProvider
extends GenericDataProvider {
    protected Consumer<class_161> advancementConsumer;
    protected BiConsumer<class_161, ConditionJsonProvider> conditionalConsumer;

    public AdvancementsProvider(FabricDataOutput output) {
        super(output, "advancements");
    }

    public String method_10321() {
        return "Tinkers' Construct Advancements";
    }

    protected void generate() {
        class_161 materialsAndYou = this.builder(TinkerCommons.materialsAndYou, this.resource("tools/materials_and_you"), this.resource("textures/gui/advancement_background.png"), class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.materialsAndYou)));
        class_161 partBuilder = this.builder(TinkerTables.partBuilder, this.resource("tools/part_builder"), materialsAndYou, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_block", this.hasItem(TinkerTables.partBuilder)));
        this.builder(TinkerToolParts.pickHead.get().withMaterialForDisplay(MaterialIds.wood), this.resource("tools/make_part"), partBuilder, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_part", this.hasTag(TinkerTags.Items.TOOL_PARTS)));
        class_161 tinkerStation = this.builder(TinkerTables.tinkerStation, this.resource("tools/tinker_station"), partBuilder, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_block", this.hasItem(TinkerTables.tinkerStation)));
        class_161 tinkerTool = this.builder(TinkerTools.pickaxe.get().getRenderTool(), this.resource("tools/tinker_tool"), tinkerStation, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_tool", this.hasTag(TinkerTags.Items.MULTIPART_TOOL)));
        this.builder((class_1935)TinkerMaterials.manyullyn.getIngot(), this.resource("tools/material_master"), tinkerTool, class_189.field_1250, (class_161.class_162 builder) -> {
            Consumer<MaterialId> with = id -> builder.method_709(id.method_12832(), (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{ToolPredicate.builder().withMaterial((MaterialId)id).build()}));
            with.accept(MaterialIds.wood);
            with.accept(MaterialIds.flint);
            with.accept(MaterialIds.rock);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.leather);
            with.accept(MaterialIds.string);
            with.accept(MaterialIds.vine);
            with.accept(MaterialIds.bamboo);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.searedStone);
            with.accept(MaterialIds.scorchedStone);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.slimewood);
            with.accept(MaterialIds.chain);
            with.accept(MaterialIds.skyslimeVine);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.slimesteel);
            with.accept(MaterialIds.nahuatl);
            with.accept(MaterialIds.amethystBronze);
            with.accept(MaterialIds.pigIron);
            with.accept(MaterialIds.cobalt);
            with.accept(MaterialIds.darkthread);
            with.accept(MaterialIds.manyullyn);
            with.accept(MaterialIds.hepatizon);
            with.accept(MaterialIds.queensSlime);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.ancientHide);
            with.accept(MaterialIds.enderslimeVine);
        });
        this.builder(TinkerTools.travelersGear.get(ArmorSlotType.HELMET).getRenderTool(), this.resource("tools/travelers_gear"), tinkerStation, class_189.field_1254, (class_161.class_162 builder) -> TinkerTools.travelersGear.forEach((type, armor) -> builder.method_709("crafted_" + type.method_15434(), this.hasItem((class_1935)armor))));
        this.builder(TinkerTools.pickaxe.get().getRenderTool(), this.resource("tools/tool_smith"), tinkerTool, class_189.field_1250, (class_161.class_162 builder) -> {
            Consumer<class_1792> with = item -> builder.method_709(Objects.requireNonNull(class_7923.field_41178.method_10221(item)).method_12832(), this.hasItem((class_1935)item));
            with.accept(TinkerTools.pickaxe.get());
            with.accept(TinkerTools.mattock.get());
            with.accept(TinkerTools.pickadze.get());
            with.accept(TinkerTools.handAxe.get());
            with.accept(TinkerTools.kama.get());
            with.accept(TinkerTools.dagger.get());
            with.accept(TinkerTools.sword.get());
        });
        class_161 modified = this.builder((class_1935)class_1802.field_8725, this.resource("tools/modified"), tinkerTool, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_tool", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{ToolPredicate.builder().hasUpgrades(true).build()})));
        this.builder((class_1935)class_1802.field_8674, this.resource("tools/upgrade_slots"), modified, class_189.field_1250, (class_161.class_162 builder) -> builder.method_709("has_modified", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{ToolPredicate.builder().upgrades(ModifierMatch.list(5, ModifierMatch.entry(ModifierIds.writable), ModifierMatch.entry(ModifierIds.recapitated), ModifierMatch.entry(ModifierIds.harmonious), ModifierMatch.entry(ModifierIds.resurrected), ModifierMatch.entry(ModifierIds.gilded))).build()})));
        class_161 punySmelting = this.builder(TinkerCommons.punySmelting, this.resource("smeltery/puny_smelting"), materialsAndYou, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.punySmelting)));
        class_161 melter = this.builder(TinkerSmeltery.searedMelter, this.resource("smeltery/melter"), punySmelting, class_189.field_1254, (class_161.class_162 builder) -> {
            Consumer<class_2248> with = block -> builder.method_709(Objects.requireNonNull(class_7923.field_41175.method_10221(block)).method_12832(), (class_184)class_4711.class_4712.method_51710((class_2248)block));
            with.accept(TinkerSmeltery.searedMelter.get());
            with.accept(TinkerSmeltery.searedTable.get());
            with.accept(TinkerSmeltery.searedBasin.get());
            with.accept(TinkerSmeltery.searedFaucet.get());
            with.accept(TinkerSmeltery.searedHeater.get());
            TinkerSmeltery.searedTank.forEach(with);
            builder.method_704((class_193)new CountRequirementsStrategy(1, 1, 1, 1, 1 + SearedTankBlock.TankType.values().length));
        });
        this.builder((class_1935)TinkerSmeltery.toolHandleCast.getSand(), this.resource("smeltery/sand_casting"), melter, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_cast", this.hasTag(TinkerTags.Items.BLANK_SINGLE_USE_CASTS)));
        class_161 goldCasting = this.builder((class_1935)TinkerSmeltery.pickHeadCast, this.resource("smeltery/gold_casting"), melter, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_cast", this.hasTag(TinkerTags.Items.GOLD_CASTS)));
        this.builder((class_1935)TinkerSmeltery.hammerHeadCast, this.resource("smeltery/cast_collector"), goldCasting, class_189.field_1249, (class_161.class_162 builder) -> {
            Consumer<CastItemObject> with = cast -> builder.method_709(cast.getName().method_12832(), this.hasItem((class_1935)cast.get()));
            with.accept(TinkerSmeltery.ingotCast);
            with.accept(TinkerSmeltery.nuggetCast);
            with.accept(TinkerSmeltery.gemCast);
            with.accept(TinkerSmeltery.rodCast);
            with.accept(TinkerSmeltery.repairKitCast);
            with.accept(TinkerSmeltery.pickHeadCast);
            with.accept(TinkerSmeltery.smallAxeHeadCast);
            with.accept(TinkerSmeltery.smallBladeCast);
            with.accept(TinkerSmeltery.hammerHeadCast);
            with.accept(TinkerSmeltery.broadBladeCast);
            with.accept(TinkerSmeltery.broadAxeHeadCast);
            with.accept(TinkerSmeltery.toolBindingCast);
            with.accept(TinkerSmeltery.roundPlateCast);
            with.accept(TinkerSmeltery.largePlateCast);
            with.accept(TinkerSmeltery.toolHandleCast);
            with.accept(TinkerSmeltery.toughHandleCast);
            with.accept(TinkerSmeltery.bowLimbCast);
            with.accept(TinkerSmeltery.bowGripCast);
        });
        class_161 mightySmelting = this.builder(TinkerCommons.mightySmelting, this.resource("smeltery/mighty_smelting"), melter, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.mightySmelting)));
        class_161 smeltery = this.builder(TinkerSmeltery.smelteryController, this.resource("smeltery/structure"), mightySmelting, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("open_smeltery", (class_184)BlockContainerOpenedTrigger.Instance.container((class_2591)TinkerSmeltery.smeltery.get())));
        class_161 anvil = this.builder(TinkerTables.tinkersAnvil, this.resource("smeltery/tinkers_anvil"), smeltery, class_189.field_1249, (class_161.class_162 builder) -> {
            builder.method_709("crafted_overworld", this.hasItem(TinkerTables.tinkersAnvil));
            builder.method_709("crafted_nether", this.hasItem(TinkerTables.scorchedAnvil));
            builder.method_704(class_193.field_1257);
        });
        this.builder(TinkerTools.veinHammer.get().getRenderTool(), this.resource("smeltery/tool_forge"), anvil, class_189.field_1250, (class_161.class_162 builder) -> {
            Consumer<class_1792> with = item -> builder.method_709(Objects.requireNonNull(class_7923.field_41178.method_10221(item)).method_12832(), this.hasItem((class_1935)item));
            with.accept(TinkerTools.sledgeHammer.get());
            with.accept(TinkerTools.veinHammer.get());
            with.accept(TinkerTools.excavator.get());
            with.accept(TinkerTools.broadAxe.get());
            with.accept(TinkerTools.scythe.get());
            with.accept(TinkerTools.cleaver.get());
            with.accept((class_1792)TinkerTools.longbow.get());
        });
        this.builder(TinkerModifiers.silkyCloth, this.resource("smeltery/abilities"), anvil, class_189.field_1250, (class_161.class_162 builder) -> {
            Consumer<ModifierId> with = modifier -> builder.method_709(modifier.method_12832(), (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{ToolPredicate.builder().modifiers(ModifierMatch.entry(modifier)).build()}));
            Consumer<LazyModifier> withL = modifier -> with.accept(modifier.getId());
            with.accept(ModifierIds.gilded);
            with.accept(ModifierIds.luck);
            with.accept(ModifierIds.reach);
            withL.accept(TinkerModifiers.unbreakable);
            withL.accept(TinkerModifiers.aquaAffinity);
            withL.accept(TinkerModifiers.bouncy);
            withL.accept(TinkerModifiers.doubleJump);
            withL.accept(TinkerModifiers.flamewake);
            withL.accept(TinkerModifiers.frostWalker);
            withL.accept(TinkerModifiers.pathMaker);
            withL.accept(TinkerModifiers.plowing);
            with.accept(ModifierIds.pockets);
            withL.accept(TinkerModifiers.slurping);
            withL.accept(TinkerModifiers.snowdrift);
            with.accept(ModifierIds.strength);
            with.accept(ModifierIds.toolBelt);
            withL.accept(TinkerModifiers.ambidextrous);
            withL.accept(TinkerModifiers.zoom);
            withL.accept(TinkerModifiers.longFall);
            withL.accept(TinkerModifiers.reflecting);
            withL.accept(TinkerModifiers.autosmelt);
            withL.accept(TinkerModifiers.exchanging);
            withL.accept(TinkerModifiers.expanded);
            withL.accept(TinkerModifiers.silky);
            withL.accept(TinkerModifiers.bucketing);
            withL.accept(TinkerModifiers.firestarter);
            withL.accept(TinkerModifiers.glowing);
            withL.accept(TinkerModifiers.pathing);
            withL.accept(TinkerModifiers.stripping);
            withL.accept(TinkerModifiers.tilling);
            withL.accept(TinkerModifiers.dualWielding);
            withL.accept(TinkerModifiers.melting);
            withL.accept(TinkerModifiers.spilling);
            withL.accept(TinkerModifiers.blocking);
            withL.accept(TinkerModifiers.parrying);
            withL.accept(TinkerModifiers.crystalshot);
            withL.accept(TinkerModifiers.multishot);
            withL.accept(TinkerModifiers.bulkQuiver);
            withL.accept(TinkerModifiers.trickQuiver);
        });
        class_161 fantasticFoundry = this.builder(TinkerCommons.fantasticFoundry, this.resource("foundry/fantastic_foundry"), materialsAndYou, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.fantasticFoundry)));
        this.builder(TinkerCommons.encyclopedia, this.resource("foundry/encyclopedia"), fantasticFoundry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.encyclopedia)));
        class_161 alloyer = this.builder(TinkerSmeltery.scorchedAlloyer, this.resource("foundry/alloyer"), fantasticFoundry, class_189.field_1254, (class_161.class_162 builder) -> {
            Consumer<class_2248> with = block -> builder.method_709(Objects.requireNonNull(class_7923.field_41175.method_10221(block)).method_12832(), (class_184)class_4711.class_4712.method_51710((class_2248)block));
            with.accept(TinkerSmeltery.scorchedAlloyer.get());
            with.accept(TinkerSmeltery.scorchedFaucet.get());
            with.accept(TinkerSmeltery.scorchedTable.get());
            with.accept(TinkerSmeltery.scorchedBasin.get());
            for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
                with.accept(TinkerSmeltery.scorchedTank.get(type));
            }
            builder.method_704((class_193)new CountRequirementsStrategy(1, 1, 1, 1, 2, 2));
        });
        class_161 foundry = this.builder(TinkerSmeltery.foundryController, this.resource("foundry/structure"), alloyer, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("open_foundry", (class_184)BlockContainerOpenedTrigger.Instance.container((class_2591)TinkerSmeltery.foundry.get())));
        class_161 blazingBlood = this.builder(TankItem.setTank(new class_1799((class_1935)TinkerSmeltery.scorchedTank.get(SearedTankBlock.TankType.FUEL_GAUGE)), AdvancementsProvider.getTankWith((class_3611)TinkerFluids.blazingBlood.get(), SearedTankBlock.TankType.FUEL_GAUGE.getCapacity())), this.resource("foundry/blaze"), foundry, class_189.field_1249, (class_161.class_162 builder) -> {
            Consumer<SearedTankBlock> with = block -> {
                class_2487 nbt = new class_2487();
                nbt.method_10566("tank", (class_2520)AdvancementsProvider.getTankWith((class_3611)TinkerFluids.blazingBlood.get(), block.getCapacity()).writeToNBT(new class_2487()));
                builder.method_709(Objects.requireNonNull(class_7923.field_41175.method_10221(block)).method_12832(), (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{block}).method_20399(nbt).method_8976()}));
                builder.method_704(class_193.field_1257);
            };
            TinkerSmeltery.searedTank.forEach(with);
            TinkerSmeltery.scorchedTank.forEach(with);
        });
        this.builder(TinkerTools.plateArmor.get(ArmorSlotType.CHESTPLATE).getRenderTool(), this.resource("foundry/plate_armor"), blazingBlood, class_189.field_1249, (class_161.class_162 builder) -> TinkerTools.plateArmor.forEach((type, armor) -> builder.method_709("crafted_" + type.method_15434(), this.hasItem((class_1935)armor))));
        this.builder(TankItem.setTank(new class_1799(TinkerSmeltery.scorchedLantern), AdvancementsProvider.getTankWith((class_3611)TinkerFluids.moltenManyullyn.get(), TinkerSmeltery.scorchedLantern.get().getCapacity())), this.resource("foundry/manyullyn_lanterns"), foundry, class_189.field_1250, (class_161.class_162 builder) -> {
            Consumer<SearedLanternBlock> with = block -> {
                class_2487 nbt = new class_2487();
                nbt.method_10566("tank", (class_2520)AdvancementsProvider.getTankWith((class_3611)TinkerFluids.moltenManyullyn.get(), block.getCapacity()).writeToNBT(new class_2487()));
                builder.method_709(Objects.requireNonNull(class_7923.field_41175.method_10221(block)).method_12832(), (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{new class_2073(null, Collections.singleton(block.method_8389()), class_2096.class_2100.method_9053((int)64), class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, new class_2105(nbt))}));
                builder.method_704(class_193.field_1257);
            };
            with.accept(TinkerSmeltery.searedLantern.get());
            with.accept(TinkerSmeltery.scorchedLantern.get());
        });
        class_161 tinkersGadgetry = this.builder(TinkerCommons.tinkersGadgetry, this.resource("world/tinkers_gadgetry"), materialsAndYou, class_189.field_1254, (class_161.class_162 builder) -> builder.method_709("crafted_book", this.hasItem(TinkerCommons.tinkersGadgetry)));
        this.builder((class_1935)TinkerWorld.slimeSapling.get(SlimeType.EARTH), this.resource("world/earth_island"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("found_island", (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(TinkerStructures.earthSlimeIslandKey))));
        this.builder((class_1935)TinkerWorld.slimeSapling.get(SlimeType.SKY), this.resource("world/sky_island"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("found_island", (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(TinkerStructures.skySlimeIslandKey))));
        this.builder((class_1935)TinkerWorld.slimeSapling.get(SlimeType.BLOOD), this.resource("world/blood_island"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("found_island", (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(TinkerStructures.bloodIslandKey))));
        class_161 enderslimeIsland = this.builder((class_1935)TinkerWorld.slimeSapling.get(SlimeType.ENDER), this.resource("world/ender_island"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("found_island", (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(TinkerStructures.endSlimeIslandKey))));
        this.builder((class_1935)class_1802.field_8696, this.resource("world/clay_island"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("found_island", (class_184)class_2135.class_2137.method_43137((class_2090)class_2090.method_9017(TinkerStructures.clayIslandKey))));
        class_161 slimes = this.builder((class_1935)TinkerCommons.slimeball.get(SlimeType.ICHOR), this.resource("world/slime_collector"), tinkersGadgetry, class_189.field_1254, (class_161.class_162 builder) -> {
            for (SlimeType type : SlimeType.values()) {
                builder.method_709(type.method_15434(), this.hasTag(type.getSlimeballTag()));
            }
            builder.method_709("magma_cream", this.hasItem((class_1935)class_1802.field_8135));
        });
        this.builder((class_1935)TinkerGadgets.slimeSling.get(SlimeType.ENDER), this.resource("world/slime_sling"), slimes, class_189.field_1250, (class_161.class_162 builder) -> {
            JsonObject boundJSON = new JsonObject();
            boundJSON.addProperty("max", (Number)150);
            class_2096.class_2100 mojangDeletedTheMaxMethods = class_2096.class_2100.method_9056((JsonElement)boundJSON);
            TinkerGadgets.slimeSling.forEach((type, sling) -> builder.method_709(type.method_15434(), (class_184)class_2069.class_2071.method_8967((class_5258)class_5258.field_24388, (class_2073)class_2073.class_2074.method_8973().method_8977(new class_1935[]{sling}).method_8976(), (class_2096.class_2100)mojangDeletedTheMaxMethods)));
        });
        this.builder(TinkerGadgets.piggyBackpack, this.resource("world/piggybackpack"), tinkersGadgetry, class_189.field_1249, (class_161.class_162 builder) -> builder.method_709("used_pack", (class_184)class_5409.class_5410.method_30099((class_5258)class_5258.field_24388, (class_2073.class_2074)class_2073.class_2074.method_8973().method_8977(new class_1935[]{TinkerGadgets.piggyBackpack}), (class_5258)class_2048.method_51704((class_2048)class_2048.class_2049.method_8916().method_8921(class_1299.field_6093).method_8920()))));
        class_161 slimesuit = this.builder(TinkerTools.slimesuit.get(ArmorSlotType.CHESTPLATE).getRenderTool(), this.resource("world/slimesuit"), enderslimeIsland, class_189.field_1249, (class_161.class_162 builder) -> TinkerTools.slimesuit.forEach((type, armor) -> builder.method_709("crafted_" + type.method_15434(), this.hasItem((class_1935)armor))));
        this.builder(new MaterialIdNBT(Collections.singletonList(MaterialIds.glass)).updateStack(new class_1799((class_1935)TinkerTools.slimesuit.get(ArmorSlotType.HELMET))), this.resource("world/slimeskull"), slimesuit, class_189.field_1250, (class_161.class_162 builder) -> {
            class_1792 helmet = (class_1792)TinkerTools.slimesuit.get(ArmorSlotType.HELMET);
            Consumer<MaterialId> with = mat -> builder.method_709(mat.method_12832(), (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{ToolPredicate.builder(helmet).withMaterial((MaterialId)mat).build()}));
            with.accept(MaterialIds.glass);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.rottenFlesh);
            with.accept(MaterialIds.enderPearl);
            with.accept(MaterialIds.bloodbone);
            with.accept(MaterialIds.string);
            with.accept(MaterialIds.darkthread);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.gold);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.pigIron);
        });
        this.hiddenBuilder(this.resource("internal/starting_book"), ConfigEnabledCondition.SPAWN_WITH_BOOK, builder -> {
            builder.method_709("tick", (class_184)class_2135.class_2137.method_49195());
            builder.method_703(class_170.class_171.method_34899((class_2960)TConstruct.getResource("gameplay/starting_book")));
        });
    }

    private static FluidTank getTankWith(class_3611 fluid, long capacity) {
        FluidTank tank = new FluidTank(capacity);
        TransferUtil.insert((Storage)tank, (Object)FluidVariant.of((class_3611)fluid), (long)capacity);
        return tank;
    }

    private class_184 hasTag(class_6862<class_1792> tag) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(tag).method_8976()});
    }

    private class_184 hasItem(class_1935 item) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{item}).method_8976()});
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.advancementConsumer = advancement -> {
            if (!set.add(advancement.method_688())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.method_688());
            }
            futures.add(this.saveThing(cache, advancement.method_688(), advancement.method_689().method_698()));
        };
        this.conditionalConsumer = (advancement, condition) -> {
            if (!set.add(advancement.method_688())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.method_688());
            }
            JsonObject jsonObject = advancement.method_689().method_698();
            ConditionJsonProvider.write((JsonObject)jsonObject, (ConditionJsonProvider[])new ConditionJsonProvider[]{condition});
            futures.add(this.saveThing(cache, advancement.method_688(), jsonObject));
        };
        this.generate();
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected class_2960 resource(String name) {
        return TConstruct.getResource(name);
    }

    protected class_161 builder(class_1935 display, class_2960 name, class_161 parent, class_189 frame, Consumer<class_161.class_162> consumer) {
        return this.builder(new class_1799(display), name, parent, frame, consumer);
    }

    protected class_161 builder(class_1799 display, class_2960 name, class_161 parent, class_189 frame, Consumer<class_161.class_162> consumer) {
        return this.builder(display, name, (class_2960)null, frame, (class_161.class_162 builder) -> {
            builder.method_701(parent);
            consumer.accept((class_161.class_162)builder);
        });
    }

    protected class_161 builder(class_1935 display, class_2960 name, @Nullable class_2960 background, class_189 frame, Consumer<class_161.class_162> consumer) {
        return this.builder(new class_1799(display), name, background, frame, consumer);
    }

    private static String makeTranslationKey(class_2960 advancement) {
        return "advancements." + advancement.method_12836() + "." + advancement.method_12832().replace('/', '.');
    }

    protected class_161 builder(class_1799 display, class_2960 name, @Nullable class_2960 background, class_189 frame, Consumer<class_161.class_162> consumer) {
        class_161.class_162 builder = class_161.class_162.method_707().method_20416(display, (class_2561)class_2561.method_43471((String)(AdvancementsProvider.makeTranslationKey(name) + ".title")), (class_2561)class_2561.method_43471((String)(AdvancementsProvider.makeTranslationKey(name) + ".description")), background, frame, true, frame != class_189.field_1254, false);
        consumer.accept(builder);
        return builder.method_694(this.advancementConsumer, name.toString());
    }

    protected void hiddenBuilder(class_2960 name, ConditionJsonProvider condition, Consumer<class_161.class_162> consumer) {
        class_161.class_162 builder = class_161.class_162.method_707();
        consumer.accept(builder);
        builder.method_694(advancement -> this.conditionalConsumer.accept((class_161)advancement, condition), name.toString());
    }
}

